'/***
'*malloc.h - declarations and definitions for memory allocation functions
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       Contains the function declarations for memory allocation functions;
'*       also defines manifest constants and types used by the heap routines.
'*       [System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%MALLOC_INC)
    %MALLOC_INC = 1

'typedef unsigned int size_t;

'/* Maximum heap request the heap manager will attempt */

%HEAP_MAXREQ    = &HFFFFFFE0???

'/* Constants for _heapchk/_heapset/_heapwalk routines */

%HEAPEMPTY      = -1
%HEAPOK         = -2
%HEAPBADBEGIN   = -3
%HEAPBADNODE    = -4
%HEAPEND        = -5
%HEAPBADPTR     = -6
%FREEENTRY      = 0
%USEDENTRY      = 1

#If Not %Def(%HEAPINFO_DEFINED)
%HEAPINFO_DEFINED = 1
Type HEAPINFO
   pentry  As Long Ptr   ' int * _pentry
   Size    As Dword      ' size_t _size
   useflag As Long       ' int _useflag
End Type
#EndIf

'/* External variable declarations */

'extern unsigned int _amblksiz;

Function pb_amblksiz () As Long
   Local hLib As Dword
   Local pamblksiz As Long Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      pamblksiz = GetProcAddress(hLib, "_amblksiz")
      If pamblksiz Then Function = @pamblksiz
      FreeLibrary hLib
   End If
End Function

'/* Function prototypes */

' Note: calloc, free, malloc and realloc are also declared in stdlib.inc

'_CRTIMP void *  __cdecl calloc(size_t, size_t);
Declare Function calloc CDecl Lib "msvcrt.dll" Alias "calloc" ( _
   ByVal Dword, _                           ' size_t num
   ByVal Dword _                            ' size_t size
   ) As Dword                               ' void *

'_CRTIMP void    __cdecl free(void *);
Declare Sub Free CDecl Lib "msvcrt.dll" Alias "free" ()

'_CRTIMP void *  __cdecl malloc(size_t);
Declare Function malloc CDecl Lib "msvcrt.dll" Alias "malloc" ( _
   ByVal Dword _                            ' size_t size
   ) As Dword                               ' void *

'_CRTIMP void *  __cdecl realloc(void *, size_t);
Declare Function realloc CDecl Lib "msvcrt.dll" Alias "realloc" ( _
   ByVal Dword, _                           ' void *memblock
   ByVal Dword _                            ' size_t size
   ) As Dword                               ' void *

' alloca = Intrinsic - Not exporter
'void *          __cdecl _alloca(size_t);

'_CRTIMP void *  __cdecl _expand(void *, size_t);
Declare Function expand CDecl Lib "msvcrt.dll" Alias "_expand" ( _
   ByVal Dword, _                           ' void *memblock
   ByVal Dword _                            ' size_t size
   ) As Dword                               ' void *

'_CRTIMP size_t  __cdecl _get_sbh_threshold(void);
Declare Function get_sbh_threshold CDecl Lib "msvcrt.dll" Alias "_get_sbh_threshold" ( _
   ) As Dword                               ' size_t

'_CRTIMP int     __cdecl _set_sbh_threshold(size_t);
Declare Function set_sbh_threshold CDecl Lib "msvcrt.dll" Alias "_set_sbh_threshold" ( _
   ByVal Dword _                            ' size_t size
   ) As Long                                ' int

'_CRTIMP int     __cdecl _heapadd(void *, size_t);
Declare Function heapadd CDecl Lib "msvcrt.dll" Alias "_heapadd" ( _
   ByVal Dword, _                           ' void *memblock
   ByVal Dword _                            ' size_t size
   ) As Long                                ' int

'_CRTIMP int     __cdecl _heapchk(void);
Declare Function heapchk CDecl Lib "msvcrt.dll" Alias "_heapchk" ( _
   ) As Long                                ' int

'_CRTIMP int     __cdecl _heapmin(void);
Declare Function heapmin CDecl Lib "msvcrt.dll" Alias "_heapmin" ( _
   ) As Long                                ' int

'_CRTIMP int     __cdecl _heapset(unsigned int);
Declare Function heapset CDecl Lib "msvcrt.dll" Alias "_heapset" ( _
   ByVal Dword _                            ' unsigned int fill
   ) As Long                                ' int

'_CRTIMP int     __cdecl _heapwalk(_HEAPINFO *);
' Note: Added underscore because the name conflicts with the API HeapWalk function.
Declare Function heapwalk_ CDecl Lib "msvcrt.dll" Alias "_heapwalk" ( _
   ByRef HEAPINFO _                         ' _HEAPINFO *entryinfo
   ) As Long                                ' int

'_CRTIMP size_t  __cdecl _heapused(size_t *, size_t *);
Declare Function heapused CDecl Lib "msvcrt.dll" Alias "_heapused" ( _
   ByRef Dword, _                           ' size_t pUsed
   ByRef Dword _                            ' size_t pCommit
   ) As Long                                ' int

'_CRTIMP size_t  __cdecl _msize(void *);
Declare Function msize CDecl Lib "msvcrt.dll" Alias "_msize" ( _
   ByVal Dword _                            ' void *memblock
   ) As Dword                               ' size_t

#If %Def(%HEAPHOOK)
'#ifndef _HEAPHOOK_DEFINED
'/* hook function type */
'typedef int (__cdecl * _HEAPHOOK)(int, size_t, void *, void **);
'#define _HEAPHOOK_DEFINED
'#endif  /* _HEAPHOOK_DEFINED */

'/* set hook function */
'_CRTIMP _HEAPHOOK __cdecl _setheaphook(_HEAPHOOK);
' Note: Not exported.
'DECLARE FUNCTION setheaphook CDECL LIB "msvcrt.dll" ALIAS "_setheaphook" ( _
'   BYVAL DWORD _                            ' _HEAPHOOK
'   ) AS DWORD                               ' _HEAPHOOK

'/* hook function must handle these types */
%HEAP_MALLOC   = 1
%HEAP_CALLOC   = 2
%HEAP_FREE     = 3
%HEAP_REALLOC  = 4
%HEAP_MSIZE    = 5
%HEAP_EXPAND   = 6
#EndIf   ' /* HEAPHOOK */

#EndIf   ' #IF NOT %DEF(%MALLOC_INC)